/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.Timer;
import java.util.Vector;

public class TimerDispatcher
implements Runnable {
    private static TimerDispatcher theDispatcher;
    private Thread myThread = null;
    private Vector timers = new Vector();
    private boolean active;

    void setThread(Thread t) {
        if (this.myThread == null) {
            this.myThread = t;
        }
    }

    public synchronized Timer add(Timer t) {
        if (this.myThread == null) {
            this.myThread = new Thread(this);
            this.start();
        }
        while (!this.addTimer(t)) {
            t.setExpirationTime(t.expirationTime() + 1L);
        }
        if (this.timers.firstElement() == t) {
            this.notifyAll();
        }
        return t;
    }

    public synchronized void remove(Timer t) {
        this.timers.removeElement(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (this.active) {
                Timer t = null;
                TimerDispatcher timerDispatcher = this;
                synchronized (timerDispatcher) {
                    while (this.active) {
                        long timeToWait = 0L;
                        if (!this.timers.isEmpty()) {
                            t = (Timer)this.timers.firstElement();
                            if (t.isExpired()) {
                                this.timers.removeElement(t);
                                break;
                            }
                            timeToWait = t.expirationTime() - System.currentTimeMillis();
                            if (timeToWait <= 0L) {
                                timeToWait = 1L;
                            }
                        }
                        this.wait(timeToWait);
                    }
                }
                if (!this.active) continue;
                t.fire();
            }
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        this.timers.removeAllElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() {
        Thread thread = this.myThread;
        synchronized (thread) {
            this.active = true;
            this.myThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        if (this.myThread != null) {
            Thread thread = this.myThread;
            synchronized (thread) {
                if (Thread.currentThread().equals(this.myThread)) {
                    System.out.println("Deadlock avoidance: TimerDispatcher thread calling stop on itself!");
                } else {
                    this.active = false;
                    TimerDispatcher timerDispatcher = this;
                    synchronized (timerDispatcher) {
                        this.notifyAll();
                    }
                    try {
                        this.myThread.join();
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                }
                this.myThread = null;
            }
        }
    }

    public static TimerDispatcher getTimerDispatcher() {
        if (theDispatcher == null) {
            theDispatcher = new TimerDispatcher();
        }
        return theDispatcher;
    }

    static void setTimerDispatcher(TimerDispatcher td) {
        theDispatcher = td;
    }

    private boolean addTimer(Timer t) {
        if (!this.timers.contains(t)) {
            int size = this.timers.size();
            int i = 0;
            while (i < size) {
                Timer t1 = (Timer)this.timers.elementAt(i);
                if (t.expirationTime() < t1.expirationTime()) {
                    this.timers.insertElementAt(t, i);
                    return true;
                }
                ++i;
            }
            this.timers.addElement(t);
            return true;
        }
        return false;
    }
}

